;;  Programm:      ACM-LOESCHENOTF.LSP
;;  Befehlsaufruf: ACM-LOESCHENOTF
;;  Funktion:      Auswahlsatz lschen, der mittels eines Objekttypfilters gebildet wurde.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         18.02.2023
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-loeschenotf ( / rtf103 rtf104 rtf105 trf001 trf002 trf003 trf004 trf005 trf006 trf007 trf008 trf009 trf010 trf011 trf012 trf013 trf014 trf015 trf016 trf017 trf018)
    (defun trf001 ( / rtf016 rtf017 rtf019)
      (setq rtf016 (trf005))
        (if (= rtf016 0)
          (setq rtf017 (trf006))
        )
        (if (= rtf016 1)
          (setq rtf017 jac9et62mfha_jk476sha)
        )
        (if (= rtf016 2)
          (setq rtf017 (trf018))
        )
        (if rtf017
          (progn
            (setq jac9et62mfha_jk476sha rtf017)
            (trf003)
              (if (setq rtf019 (trf004 rtf017))
                (progn
                  (vl-cmdf "._erase" rtf019 "")
                  (prompt (strcat "\n" (itoa (sslength rtf019)) " Objekt(e) gelscht. "))
                )
                (prompt "\n0 Objekte gelscht. ")
              )
          )
        )
    )
    (defun trf002 (rtf001 / )
        (if rtf105
          (setq *error* rtf105)
        )
        (if rtf103
          (vl-catch-all-apply 'setvar (list "CMDECHO" rtf103))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun trf003 ( / rtf020 rtf021 rtf022 rtf023 rtf024 rtf025 rtf026 rtf027)
        (setq rtf020
          (list
            (cons "POLYLINE" "2D-Polylinie")
            (cons "3DFACE" "3D-Flche")
            (cons "POLYLINE" "3D-Polylinie")
            (cons "3DSOLID" "3D-Volumenkrper")
            (cons "VIEWPORT" "Ansichtsfenster")
            (cons "ATTDEF" "Attributdefinition")
            (cons "TRACE" "Band")
            (cons "*DIMENSION*" "Bemaung")
            (cons "INSERT" "Blockreferenz")
            (cons "ARC" "Bogen")
            (cons "ARCALIGNEDTEXT" "Bogentext")
            (cons "DWFUNDERLAY" "DWF-Unterlage")
            (cons "ELLIPSE" "Ellipse")
            (cons "INSERT" "Externe Referenz")
            (cons "LEADER" "Fhrung")
            (cons "CAMERA" "Kamera")
            (cons "XLINE" "Klinie")
            (cons "CIRCLE" "Kreis")
            (cons "LIGHT" "Licht")
            (cons "LINE" "Linie")
            (cons "INSERT" "Meinfg Block")
            (cons "MTEXT" "MText")
            (cons "MULTILEADER" "Multi-Fhrungslinie")
            (cons "MLINE" "Multilinie")
            (cons "MESH" "Netz")
            (cons "IMAGE" "Pixelbild")
            (cons "POLYLINE" "Polygonnetz")
            (cons "LWPOLYLINE" "Polylinie")
            (cons "POINT" "Punkt")
            (cons "REGION" "Region")
            (cons "RTEXT" "RText")
            (cons "SECTIONOBJECT" "Schnittobjekt")
            (cons "HATCH" "Schraffur")
            (cons "SOLID" "Solid")
            (cons "HELIX" "Spirale")
            (cons "SPLINE" "Spline")
            (cons "RAY" "Strahl")
            (cons "SHAPE" "Symbol")
            (cons "ACAD_TABLE" "Tabelle")
            (cons "TEXT" "Text")
            (cons "TOLERANCE" "Toleranz")
            (cons "POLYLINE" "Vielflchennetz")
            (cons "BODY" "Volumenkrper")
            (cons "WIPEOUT" "Wipeout")
          )
        )
      (setq rtf021 (car jac9et62mfha_jk476sha))
      (setq rtf022 (trf016 (cdr (car (cadr jac9et62mfha_jk476sha))) ","))
        (while rtf022
          (setq rtf023 (car rtf022))
          (setq rtf024 (strcase rtf023))
            (if (not (vl-position rtf024 (list "INSERT" "POLYLINE")))
              (progn
                (if (setq rtf025 (cdr (assoc rtf024 rtf020)))
                  (setq rtf026 (cons rtf025 rtf026))
                  (setq rtf026 (cons rtf024 rtf026))
                )
              )
            )
          (setq rtf022 (cdr rtf022))
        )
        (while rtf021
          (setq rtf027 (car rtf021))
            (if (= rtf027 1)
              (setq rtf026 (cons "2D-Polylinie" rtf026))
            )
            (if (= rtf027 2)
              (setq rtf026 (cons "3D-Polylinie" rtf026))
            )
            (if (= rtf027 3)
              (setq rtf026 (cons "Polygonnetz" rtf026))
            )
            (if (= rtf027 4)
              (setq rtf026 (cons "Vielflchennetz" rtf026))
            )
            (if (= rtf027 5)
              (setq rtf026 (cons "Blockreferenz" rtf026))
            )
            (if (= rtf027 6)
              (setq rtf026 (cons "Externe Referenz" rtf026))
            )
            (if (= rtf027 7)
              (setq rtf026 (cons "Meinfg Block" rtf026))
            )
          (setq rtf021 (cdr rtf021))
        )
        (if rtf026
          (progn
            (setq rtf026 (acad_strlsort rtf026))
            (prompt "\n ")
            (prompt (strcat "\n" (itoa (length rtf026)) " Filterobjekttyp(en) gewhlt: "))
              (while rtf026
                (prompt (strcat "\n" (car rtf026) " "))
                (setq rtf026 (cdr rtf026))
              )
            (prompt "\n ")
          )
        )
    )
    (defun trf004 (rtf002 / rtf021 rtf028 rtf029 rtf030 rtf031 rtf032 rtf033 rtf034 rtf035 rtf036 rtf037 rtf038 rtf039)
      (setq rtf021 (car rtf002))
      (setq rtf028 (cadr rtf002))
      (prompt "\nZu lschende Objekte per gefilterter Objektwahl whlen ... ")
        (if (setq rtf029 (ssget rtf028))
          (progn
            (if rtf021
              (progn
                (if
                  (or
                    (vl-position 1 rtf021)
                    (vl-position 2 rtf021)
                    (vl-position 3 rtf021)
                    (vl-position 4 rtf021)
                  )
                    (setq rtf030 1)
                    (setq rtf030 0)
                )
                (if
                  (or
                    (vl-position 5 rtf021)
                    (vl-position 6 rtf021)
                    (vl-position 7 rtf021)
                  )
                    (setq rtf031 1)
                    (setq rtf031 0)
                )
                (if
                  (and
                    (= rtf030 1)
                    (= rtf031 1)
                  )
                    (setq rtf032 "POLYLINE,INSERT")
                )
                (if
                  (and
                    (= rtf030 1)
                    (= rtf031 0)
                  )
                    (setq rtf032 "POLYLINE")
                )
                (if
                  (and
                    (= rtf030 0)
                    (= rtf031 1)
                  )
                    (setq rtf032 "INSERT")
                )
                (if (setq rtf033 (ssget "_p" (list (cons 0 rtf032))))
                  (progn
                      (if (vl-position 1 rtf021)
                        (setq rtf034 (cons "ACDB2DPOLYLINE" rtf034))
                      )
                      (if (vl-position 2 rtf021)
                        (setq rtf034 (cons "ACDB3DPOLYLINE" rtf034))
                      )
                      (if (vl-position 3 rtf021)
                        (setq rtf034 (cons "ACDBPOLYGONMESH" rtf034))
                      )
                      (if (vl-position 4 rtf021)
                        (setq rtf034 (cons "ACDBPOLYFACEMESH" rtf034))
                      )
                      (if (vl-position 5 rtf021)
                        (setq rtf034 (cons "ACDBBLOCKREFERENCE" rtf034))
                      )
                      (if (vl-position 6 rtf021)
                        (setq rtf034 (cons "ACDBXREFERENCE" rtf034))
                      )
                      (if (vl-position 7 rtf021)
                        (setq rtf034 (cons "ACDBMINSERTBLOCK" rtf034))
                      )
                    (setq rtf035 -1)
                      (repeat (sslength rtf033)
                        (setq rtf035 (1+ rtf035))
                        (setq rtf036 (ssname rtf033 rtf035))
                        (ssdel rtf036 rtf029)
                        (setq rtf037 (cons (vlax-ename->vla-object rtf036) rtf037))
                      )
                      (while rtf037
                        (setq rtf038 (car rtf037))
                        (setq rtf039 (strcase (vlax-get rtf038 'ObjectName)))
                          (if (vl-position rtf039 rtf034)
                            (ssadd (vlax-vla-object->ename rtf038) rtf029)
                          )
                        (setq rtf037 (cdr rtf037))
                      )
                  )
                )
              )
            )
          )
        )
        (if
          (and
            rtf029
            (> (sslength rtf029) 0)
          )
            rtf029
            nil
        )
    )
    (defun trf005 ( / rtf041 rtf042 rtf043)
        (if (not (vl-position jac9et63mfha_jk476sha (list 0 1 2)))
          (setq jac9et63mfha_jk476sha 0)
        )
        (if (= (type jac9et62mfha_jk476sha) 'LIST)
          (progn
            (setq rtf041 "Objektwahl Vorherige Auswahlliste")
              (if (= jac9et63mfha_jk476sha 0)
                (setq rtf042 "\nFilterobjekttypen whlen durch [Objektwahl/Vorherige auswahl/Auswahlliste] <Objektwahl>: ")
              )
              (if (= jac9et63mfha_jk476sha 1)
                (setq rtf042 "\nFilterobjekttypen whlen durch [Objektwahl/Vorherige auswahl/Auswahlliste] <Vorherige auswahl>: ")
              )
              (if (= jac9et63mfha_jk476sha 2)
                (setq rtf042 "\nFilterobjekttypen whlen durch [Objektwahl/Vorherige auswahl/Auswahlliste] <Auswahlliste>: ")
              )
          )
          (progn
              (if (not (vl-position jac9et63mfha_jk476sha (list 0 2)))
                (setq jac9et63mfha_jk476sha 0)
              )
            (setq rtf041 "Objektwahl Auswahlliste")
              (if (= jac9et63mfha_jk476sha 0)
                (setq rtf042 "\nFilterobjekttypen whlen durch [Objektwahl/Auswahlliste] <Objektwahl>: ")
              )
              (if (= jac9et63mfha_jk476sha 2)
                (setq rtf042 "\nFilterobjekttypen whlen durch [Objektwahl/Auswahlliste] <Auswahlliste>: ")
              )
          )
        )
      (initget rtf041)
        (if (setq rtf043 (getkword rtf042))
          (setq jac9et63mfha_jk476sha (nth (vl-position rtf043 (list "Objektwahl" "Vorherige" "Auswahlliste")) (list 0 1 2)))
        )
      jac9et63mfha_jk476sha
    )
    (defun trf006 ( / rtf044 rtf045 rtf046)
      (prompt "\nFilterobjekttypen per Quellobjektewahl bestimmen ... ")
        (if (setq rtf044 (ssget))
          (progn
            (setq rtf045 (trf007 rtf044))
            (setq rtf046 (trf008 rtf045))
            (setq jac9et62mfha_jk476sha rtf046)
          )
        (setq rtf046 nil)
        )
      rtf046
    )
    (defun trf007 (rtf003 / rtf047 rtf048 rtf049 rtf050 rtf051 rtf052 rtf053 rtf054 rtf055 rtf056 rtf057 rtf058)
      (setq rtf047 (sslength rtf003))
      (setq rtf048 -1)
        (repeat rtf047
          (setq rtf049 nil)
          (setq rtf048 (1+ rtf048))
          (setq rtf050 (ssname rtf003 rtf048))
          (setq rtf051 (vlax-ename->vla-object rtf050))
          (setq rtf052 (vlax-get rtf051 'ObjectName))
          (setq rtf053 (strcase rtf052))
          (setq rtf054 (entget rtf050))
          (setq rtf055 (cdr (assoc 0 rtf054)))
          (setq rtf056 (strcase rtf055))
            (if (= rtf056 "DIMENSION")
              (setq rtf056 (strcat "*" rtf056 "*"))
            )
            (if (vl-position rtf056 (list "POLYLINE" "INSERT"))
              (progn
                (if (= rtf056 "POLYLINE")
                  (progn
                    (if (= rtf053 "ACDB2DPOLYLINE")
                      (setq rtf057 (cons 1 "POLYLINE"))
                    )
                    (if (= rtf053 "ACDB3DPOLYLINE")
                      (setq rtf057 (cons 2 "POLYLINE"))
                    )
                    (if (= rtf053 "ACDBPOLYGONMESH")
                      (setq rtf057 (cons 3 "POLYLINE"))
                    )
                    (if (= rtf053 "ACDBPOLYFACEMESH")
                      (setq rtf057 (cons 4 "POLYLINE"))
                    )
                  )
                )
                (if (= rtf056 "INSERT")
                  (progn
                    (if (= rtf053 "ACDBBLOCKREFERENCE")
                      (setq rtf057 (cons 5 "INSERT"))
                    )
                    (if (= rtf053 "ACDBXREFERENCE")
                      (setq rtf057 (cons 6 "INSERT"))
                    )
                    (if (= rtf053 "ACDBMINSERTBLOCK")
                      (setq rtf057 (cons 7 "INSERT"))
                    )
                  )
                )
              )
              (setq rtf049 0)
            )
            (if (= rtf049 0)
              (setq rtf057 (cons 0 rtf056))
            )
            (if (not (vl-position rtf057 rtf058))
              (setq rtf058 (cons rtf057 rtf058))
            )
        )
      rtf058
    )
    (defun trf008 (rtf004 / rtf059 rtf036 rtf060 rtf061 rtf038 rtf062 rtf063 rtf064)
      (setq rtf059 rtf004)
        (while rtf059
          (setq rtf036 (car  rtf059))
            (if (not (vl-position (setq rtf060 (cdr rtf036)) rtf061))
              (setq rtf061 (cons rtf060 rtf061))
            )
          (setq rtf038 (car rtf036))
            (if (/= rtf038 0)
              (progn
                (if (not (vl-position rtf038 rtf062))
                  (setq rtf062 (cons rtf038 rtf062))
                )
              )
            )
          (setq rtf059 (cdr rtf059))
        )
      (setq rtf063 "")
        (while rtf061
          (setq rtf064 (car rtf061))
          (setq rtf063 (strcat rtf063 rtf064 ","))
          (setq rtf061 (cdr rtf061))
        )
      (setq rtf063 (trf009 rtf063 1))
        (list
          rtf062
          (list (cons 0 rtf063))
        )
    )
    (defun trf009 (rtf005 rtf006 / rtf065 rtf066)
      (setq rtf065 (strlen rtf005))
        (if (> rtf006 rtf065)
          (setq rtf006 rtf065)
        )
      (setq rtf066 (- rtf065 rtf006))
      (setq rtf005 (substr rtf005 1 rtf066))
    )
    (defun trf010 ( / rtf067 rtf068 rtf069 rtf070)
      (if
        (and
          (setq rtf067 (vl-filename-mktemp "acm.dcl"))
          (setq rtf068 (open rtf067 "w"))
        )
          (progn
              (if (= (getvar "PLINETYPE") 0)
                (setq rtf069 (list "Linienzug" "2D-Polylinie"))
                (setq rtf069 (list "Linienzug" "Polylinie"))
              )
            (setq rtf070
              (list
                "Delete"
                ":dialog{label=\042Objekttypen whlen\042;"
                ":spacer{height=0.2;}"
                ":list_box{key=\042lb_01\042;width=30;height=11;multiple_select=true;}"
                ":text{key=\042t_01\042;}"
                ":spacer{height=0.2;}"
                ":row{"
                ":spacer{width=2;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}"
                ":spacer{width=2;}}}"
              )
            )
              (while rtf070
                (write-line (car rtf070) rtf068)
                (setq rtf070 (cdr rtf070))
              )
            (setq rtf068 (close rtf068))
            rtf067
          )
          nil
      )
    )
    (defun trf011 ( / rtf071)
      (setq rtf071 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= rtf071 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq rtf072 T)
            (setq rtf072 nil)
        )
        (if (not rtf072)
          (alert "\042acm-loeschenotf\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      rtf072
    )
    (defun trf012 (rtf005 rtf007 / rtf073 rtf074 rtf075 rtf076)
      (setq rtf073 (strlen rtf005))
      (setq rtf074 1)
        (while (<= rtf074 rtf073)
          (setq rtf075 (substr rtf005 rtf074 1))
            (if (/= rtf075 rtf007)
              (progn
                (setq rtf076 nil)
                (setq rtf074 (1+ rtf074))
              )
            )
            (if (= rtf075 rtf007)
              (progn
                (setq rtf076 rtf074)
                (setq rtf074 (1+ rtf073))
              )
            )
        )
      rtf076
    )
    (defun trf013 (rtf008 rtf009 / rtf073 rtf077 rtf048 rtf078)
      (setq rtf073 (strlen rtf008))
      (setq rtf077 (substr rtf008 1 1))
      (setq rtf048 0)
        (while
          (and
            (/= (member rtf077 rtf009) nil)
            (/= rtf048 rtf073)
          )
            (setq rtf008 (substr rtf008 2))
            (setq rtf077 (substr rtf008 1 1))
            (setq rtf048 (+ rtf048 1))
        )
        (if (/= rtf048 rtf073)
          (progn
            (setq rtf073 (strlen rtf008))
            (setq rtf078 (substr rtf008 rtf073 1))
            (setq rtf048 rtf073)
              (while
                (and
                  (/= (member rtf078 rtf009) nil)
                  (/= rtf048 0)
                )
                  (setq rtf008 (substr rtf008 1 rtf048))
                  (setq rtf078 (substr rtf008 rtf048 1))
                  (setq rtf048 (- rtf048 1))
              )
          )
        )
      rtf008
    )
    (defun trf014 (rtf010 rtf011 / rtf079 rtf076 rtf080 rtf081)
      (if
        (and
          (= (type rtf010) 'STR)
          (= (type rtf011) 'STR)
        )
          (progn
            (setq rtf079 (trf013 rtf010 (list rtf011)))
            (setq rtf076 (trf012 rtf079 rtf011))
              (if rtf076
                (progn
                  (setq rtf080 (substr rtf079 1 (1- rtf076)))
                  (setq rtf079 (trf013 (substr rtf079 (1+ (strlen rtf080))) (list rtf011)))
                  (setq rtf081 (cons rtf080 rtf081))
                )
              )
            (setq rtf076 (trf012 rtf079 rtf011))
              (while rtf076
                (setq rtf080 (substr rtf079 1 (1- rtf076)))
                (setq rtf079 (trf013 (substr rtf079 (1+ (strlen rtf080))) (list rtf011)))
                (setq rtf081 (cons rtf080 rtf081))
                (setq rtf076 (trf012 rtf079 rtf011))
              )
              (if (> (strlen rtf079) 0)
                (setq rtf081 (cons rtf079 rtf081))
              )
          )
      )
      (if rtf081
        (reverse rtf081)
        nil
      )
    )
    (defun trf015 (rtf012 / rtf082 rtf083 rtf084 rtf063 rtf038 rtf024 rtf085 rtf086 rtf087)
        (setq rtf082
          (list
            (cons "2D-Polylinie" "POLYLINE")
            (cons "3D-Flche" "3DFACE")
            (cons "3D-Polylinie" "POLYLINE")
            (cons "3D-Volumenkrper" "3DSOLID")
            (cons "Ansichtsfenster" "VIEWPORT")
            (cons "Attributdefinition" "ATTDEF")
            (cons "Band" "TRACE")
            (cons "Bemaung" "*DIMENSION*")
            (cons "Blockreferenz" "INSERT")
            (cons "Bogen" "ARC")
            (cons "Bogentext" "ARCALIGNEDTEXT")
            (cons "DWF-Unterlage" "DWFUNDERLAY")
            (cons "Ellipse" "ELLIPSE")
            (cons "Externe Referenz" "INSERT")
            (cons "Fhrung" "LEADER")
            (cons "Kamera" "CAMERA")
            (cons "Klinie" "XLINE")
            (cons "Kreis" "CIRCLE")
            (cons "Licht" "LIGHT")
            (cons "Linie" "LINE")
            (cons "Meinfg Block" "INSERT")
            (cons "MText" "MTEXT")
            (cons "Multi-Fhrungslinie" "MULTILEADER")
            (cons "Multilinie" "MLINE")
            (cons "Netz" "MESH")
            (cons "Pixelbild" "IMAGE")
            (cons "Polygonnetz" "POLYLINE")
            (cons "Polylinie" "LWPOLYLINE")
            (cons "Punkt" "POINT")
            (cons "Region" "REGION")
            (cons "RText" "RTEXT")
            (cons "Schnittobjekt" "SECTIONOBJECT")
            (cons "Schraffur" "HATCH")
            (cons "Solid" "SOLID")
            (cons "Spirale" "HELIX")
            (cons "Spline" "SPLINE")
            (cons "Strahl" "RAY")
            (cons "Symbol" "SHAPE")
            (cons "Tabelle" "ACAD_TABLE")
            (cons "Text" "TEXT")
            (cons "Toleranz" "TOLERANCE")
            (cons "Vielflchennetz" "POLYLINE")
            (cons "Volumenkrper" "BODY")
            (cons "Wipeout" "WIPEOUT")
          )
        )
        (setq rtf083
          (list
            (cons "2D-Polylinie" 1)
            (cons "3D-Polylinie" 2)
            (cons "Polygonnetz" 3)
            (cons "Vielflchennetz" 4)
            (cons "Blockreferenz" 5)
            (cons "Externe Referenz" 6)
            (cons "Meinfg Block" 7)
          )
        )
      (setq rtf084 rtf012)
      (setq rtf063 "")
        (while rtf084
          (setq rtf038 (car rtf084))
            (if
              (and
                (setq rtf024 (cdr (assoc rtf038 rtf082)))
                (not (vl-position rtf024 rtf085))
              )
                (progn
                  (setq rtf063 (strcat rtf063 rtf024 ","))
                  (setq rtf085 (cons rtf024 rtf085))
                )
            )
          (setq rtf084 (cdr rtf084))
        )
      (setq rtf063 (trf009 rtf063 1))
      (setq rtf084 rtf012)
        (while rtf084
          (setq rtf038 (car rtf084))
            (if
              (and
                (setq rtf086 (cdr (assoc rtf038 rtf083)))
                (not (vl-position rtf086 rtf087))
              )
                (setq rtf087 (cons rtf086 rtf087))
            )
          (setq rtf084 (cdr rtf084))
        )
      (list rtf087 (list (cons 0 rtf063)))
    )
    (defun trf016 (rtf013 rtf014 / rtf076 rtf088)
      (if
        (and
          (= (type rtf013) 'STR)
          (= (type rtf014) 'STR)
        )
          (progn
            (setq rtf013 (trf013 rtf013 (list rtf014 " ")))
              (while (setq rtf076 (trf012 rtf013 rtf014))
                (setq rtf076 (1- rtf076))
                (setq rtf088 (append rtf088 (list (substr rtf013 1 rtf076))))
                (setq rtf013 (trf013 (substr rtf013 (1+ rtf076)) (list rtf014)))
              )
            (setq rtf088 (append rtf088 (list rtf013)))
          )
      )
      rtf088
    )
    (defun trf017 (rtf015 / rtf063 rtf082 rtf089 rtf090 rtf091 rtf038 rtf086 rtf092 rtf093 rtf094 rtf095 rtf064)
      (setq rtf063 "")
        (setq rtf082
          (list
            (cons "POLYLINE" 0)
            (cons "3DFACE" 1)
            (cons "POLYLINE" 2)
            (cons "3DSOLID" 3)
            (cons "VIEWPORT" 4)
            (cons "ATTDEF" 5)
            (cons "TRACE" 6)
            (cons "*DIMENSION*" 7)
            (cons "INSERT" 8)
            (cons "ARC" 9)
            (cons "ARCALIGNEDTEXT" 10)
            (cons "DWFUNDERLAY" 11)
            (cons "ELLIPSE" 12)
            (cons "INSERT" 13)
            (cons "LEADER" 14)
            (cons "CAMERA" 15)
            (cons "XLINE" 16)
            (cons "CIRCLE" 17)
            (cons "LIGHT" 18)
            (cons "LINE" 19)
            (cons "INSERT" 20)
            (cons "MTEXT" 21)
            (cons "MULTILEADER" 22)
            (cons "MLINE" 23)
            (cons "MESH" 24)
            (cons "IMAGE" 25)
            (cons "POLYLINE" 26)
            (cons "LWPOLYLINE" 27)
            (cons "POINT" 28)
            (cons "REGION" 29)
            (cons "RTEXT" 30)
            (cons "SECTIONOBJECT" 31)
            (cons "HATCH" 32)
            (cons "SOLID" 33)
            (cons "HELIX" 34)
            (cons "SPLINE" 35)
            (cons "RAY" 36)
            (cons "SHAPE" 37)
            (cons "ACAD_TABLE" 38)
            (cons "TEXT" 39)
            (cons "TOLERANCE" 40)
            (cons "POLYLINE" 41)
            (cons "BODY" 42)
            (cons "WIPEOUT" 43)
          )
        )
      (setq rtf089 (cdr (car (cadr rtf015))))
      (setq rtf090 (trf016 rtf089 ","))
        (if (setq rtf091 (car rtf015))
          (progn
            (setq rtf090 (vl-remove "INSERT" rtf090))
            (setq rtf090 (vl-remove "POLYLINE" rtf090))
          )
        )
        (while rtf090
          (setq rtf038 (car rtf090))
            (if
              (and
                (setq rtf086 (cdr (assoc rtf038 rtf082)))
                (not (vl-position rtf086 rtf092))
              )
                (setq rtf092 (cons rtf086 rtf092))
            )
          (setq rtf090 (cdr rtf090))
        )
        (if rtf091
          (progn
              (setq rtf093
                (list
                  (cons 1 0)
                  (cons 2 2)
                  (cons 3 26)
                  (cons 4 41)
                  (cons 5 8)
                  (cons 6 13)
                  (cons 7 20)
                )
              )
              (while rtf091
                (setq rtf094 (car rtf091))
                  (if
                    (and
                      (setq rtf095 (cdr (assoc rtf094 rtf093)))
                      (not (vl-position rtf095 rtf092))
                    )
                      (setq rtf092 (cons rtf095 rtf092))
                  )
                (setq rtf091 (cdr rtf091))
              )
          )
        )
      (setq rtf092 (vl-sort rtf092 '>))
        (while rtf092
          (setq rtf064 (car rtf092))
          (setq rtf063 (strcat rtf063 (itoa rtf064) " "))
          (setq rtf092 (cdr rtf092))
        )
      (trf009 rtf063 1)
    )
    (defun trf018 ( / rtf096 rtf097 rtf098 rtf100 rtf072 rtf101 rtf038 rtf102 rtf099)
        (if (setq rtf096 (trf010))
          (progn
            (setq rtf097 (load_dialog rtf096))
              (if (not (new_dialog "Delete" rtf097))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list rtf096))
            (setq rtf098 (list "2D-Polylinie" "3D-Flche" "3D-Polylinie" "3D-Volumenkrper" "Ansichtsfenster" "Attributdefinition" "Band" "Bemaung" "Blockreferenz" "Bogen" "Bogentext" "DWF-Unterlage" "Ellipse" "Externe Referenz" "Fhrung" "Kamera" "Klinie" "Kreis" "Licht" "Linie" "Meinfg Block" "MText" "Multi-Fhrungslinie" "Multilinie" "Netz" "Pixelbild" "Polygonnetz" "Polylinie" "Punkt" "Region" "RText" "Schnittobjekt" "Schraffur" "Solid" "Spirale" "Spline" "Strahl" "Symbol" "Tabelle" "Text" "Toleranz" "Vielflchennetz" "Volumenkrper" "Wipeout"))
            (start_list "lb_01")
            (mapcar 'add_list rtf098)
            (end_list)
              (if (/= (type jac9et62mfha_jk476sha) 'LIST)
                (mode_tile "b_01" 1)
                (set_tile "lb_01" (trf017 jac9et62mfha_jk476sha))
              )
            (setq rtf099 (itoa (length (trf014 (get_tile "lb_01") " "))))
            (set_tile "t_01" (strcat rtf099 " gewhlt"))
              (if (= rtf099 "0")
                (mode_tile "b_01" 1)
              )
              (action_tile "lb_01" "(setq rtf100 $value)
                (if (= rtf100 \"\")
                  (progn
                    (mode_tile \"b_01\" 1)
                    (set_tile \"t_01\" \"0 gewhlt\")
                  )
                  (progn
                    (mode_tile \"b_01\" 0)
                    (setq rtf099 (itoa (length (trf014 rtf100 \" \"))))
                    (set_tile \"t_01\" (strcat rtf099 \" gewhlt\"))
                  )
                )"
              )
              (action_tile "b_01" "(setq rtf100 (get_tile \"lb_01\"))
                (setq rtf072 (trf014 rtf100 \" \"))
                (setq rtf101 rtf072)
                  (while rtf101
                    (setq rtf038 (atoi (car rtf101)))
                    (setq rtf102 (cons (nth rtf038 rtf098) rtf102))
                    (setq rtf101 (cdr rtf101))
                  )
                (setq jac9et62mfha_jk476sha (trf015 rtf102))
                (done_dialog)"
              )
            (action_tile "b_02" "(setq rtf072 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog rtf097)
          )
        )
        (if rtf102
          (trf015 rtf102)
          nil
        )
    )
  (if (trf011)
    (progn
      (vl-load-com)
      (setq rtf103 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq rtf104 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq rtf105 *error*)
      (setq *error* trf002)
      (vla-EndUndoMark rtf104)
      (vla-StartUndoMark rtf104)
      (trf001)
        (if rtf105
          (setq *error* rtf105)
          (setq *error* nil)
        )
      (setvar "CMDECHO" rtf103)
      (vla-EndUndoMark rtf104)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-LOESCHENOTF (Copyright  2024 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-LOESCHENOTF auf.")
